package ru.yandex.passport;

import java.io.IOException;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.passport.document.BaseDocumentBuilder;
import ru.yandex.passport.document.Document;
import ru.yandex.passport.document.DocumentSourceService;

public class DocumentAddHandler extends DocumentsProxyHandler {
    public DocumentAddHandler(final DocumentsProxy proxy) {
        super(proxy);
    }

    @Override
    public void handle(ProxySession session, DocumentSourceService service) throws HttpException, IOException {
        if (!(session.request() instanceof HttpEntityEnclosingRequest)) {
            throw new BadRequestException("Missing request body");
        }

        session.logger().info("");
        JsonObject item;
        try {
            item = TypesafeValueContentHandler.parse(
                CharsetUtils.content(
                    ((HttpEntityEnclosingRequest) session.request()).getEntity()));
        } catch (JsonException je) {
            throw new BadRequestException("Invalid request json", je);
        }

        handle(session, item, service);
    }

    private void handle(
        ProxySession session,
        JsonObject item,
        DocumentSourceService service)
        throws HttpException, IOException
    {
        Long userId = session.params().getLong("user_id");
        BaseDocumentBuilder document;
        try {
            document = Document.parse(item.asMap());
            document.service(service);
        } catch (JsonException je) {
            throw new BadRequestException("Failed to parse document", je);
        }
        proxy.storage().put(session, userId, document, new SaveCallback(session));
    }

    private static class SaveCallback extends AbstractDocumentsProxySessionCallback<Document> {
        public SaveCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final Document o) {
            try {
                JsonType jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
                StringBuilderWriter sbw = new StringBuilderWriter();
                try (JsonWriter jw = jsonType.create(sbw)) {
                    jw.startObject();
                    jw.key("id");
                    jw.value(o.id());
                    jw.endObject();
                }

                session.response(
                    HttpStatus.SC_OK,
                    new StringEntity(sbw.toString(), ContentType.APPLICATION_JSON));
            } catch (IOException | BadRequestException ioe) {
                failed(ioe);
            }
            session.response(HttpStatus.SC_OK);
        }
    }
}
