package ru.yandex.passport;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.passport.document.DocumentSourceService;

public class DocumentDeleteHandler extends DocumentsProxyHandler {
    public DocumentDeleteHandler(final DocumentsProxy proxy) {
        super(proxy);
    }

    @Override
    public void handle(final ProxySession session, final DocumentSourceService service) throws HttpException, IOException {
        if (service != DocumentSourceService.PASSPORT && service != DocumentSourceService.TEST) {
            session.response(HttpStatus.SC_BAD_REQUEST, "Only passport can delete docs");
            return;
        }

        DeleteCallback callback = new DeleteCallback(session);

        Long userId = session.params().getLong("user_id");
        String docId = session.params().getString("id", null);
        String originalId = session.params().getString("original_id", null);

        proxy.storage().delete(session, userId, docId, originalId, callback);
    }

    private static class DeleteCallback extends AbstractDocumentsProxySessionCallback<Object> {
        public DeleteCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final Object result) {
            session.response(HttpStatus.SC_OK, "{\"status\":\"ok\"}");
        }
    }
}
