package ru.yandex.passport;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.passport.document.BaseDocumentBuilder;
import ru.yandex.passport.document.DocumentSourceService;

public class DocumentGetHandler extends DocumentsProxyHandler {
    public DocumentGetHandler(final DocumentsProxy proxy) {
        super(proxy);
    }

    @Override
    public void handle(final ProxySession session, final DocumentSourceService service) throws HttpException, IOException {
        Long userId = session.params().getLong("user_id");
        String docId = session.params().getString("id", null);
        String originalId = session.params().getString("original_id", null);
        proxy.storage().get(session, userId, docId, originalId, new GetCallback(session));
    }

    private static class GetCallback extends AbstractDocumentsProxySessionCallback<BaseDocumentBuilder> {
        public GetCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final BaseDocumentBuilder document) {
            try {
                JsonType jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
                StringBuilderWriter sbw = new StringBuilderWriter();
                try (JsonWriter jw = jsonType.create(sbw)) {
                    jw.value(document);
                }

                session.response(
                    HttpStatus.SC_OK,
                    new StringEntity(sbw.toString(), ContentType.APPLICATION_JSON));
            } catch (IOException | BadRequestException ioe) {
                failed(ioe);
            }
        }
    }
}
