package ru.yandex.passport;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.passport.document.BaseDocumentBuilder;
import ru.yandex.passport.document.DocumentSourceService;

public class DocumentImageCheckHandler extends DocumentsProxyHandler {
    public DocumentImageCheckHandler(final DocumentsProxy proxy) {
        super(proxy, false);
    }

    @Override
    public void handle(final ProxySession session, final DocumentSourceService service) throws HttpException, IOException {
        Long userId = session.params().getLong("user_id");
        String docId = session.params().getString("doc_id");
        String path = session.params().getString("path");
        proxy.storage().get(session, userId, docId, null, new GetCallback(session, path));
    }

    private static class GetCallback extends AbstractDocumentsProxySessionCallback<BaseDocumentBuilder> {
        private final String path;

        public GetCallback(ProxySession session, String path) {
            super(session);
            this.path = path;
        }

        @Override
        public void completed(final BaseDocumentBuilder document) {
            boolean imageFound = document
                    .images()
                    .stream()
                    .anyMatch(
                            image -> image.originalUri().equals("/get-id_doc/" + path)
                                    || image.previewUri().equals("/get-id_doc/" + path)
                    );

            if (imageFound) {
                session.response(HttpStatus.SC_OK);
            } else {
                session.response(HttpStatus.SC_NOT_FOUND);
            }
        }
    }
}
