package ru.yandex.passport;

import java.io.IOException;
import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.passport.document.DocumentSourceService;
import ru.yandex.passport.document.DocumentType;
import ru.yandex.passport.document.ServiceEntry;

public class DocumentServicesHandler extends DocumentsProxyHandler {
    public DocumentServicesHandler(final DocumentsProxy proxy) {
        super(proxy);
    }

    @Override
    public void handle(ProxySession session, DocumentSourceService service) throws HttpException, IOException {
        Context context = new Context(session, service);
        proxy.storage().getServices(
            session,
            context.userId(),
            context.documentType(),
            new Callback(session)
        );
    }

    private static class Context extends DocumentsContext {
        private final DocumentType documentType;

        public Context(ProxySession session, DocumentSourceService service) throws BadRequestException {
            super(session, service);
            documentType = session.params().getEnum(DocumentType.class, "doc_type", null);
        }

        public DocumentType documentType() {
            return documentType;
        }
    }

    private static class Callback extends AbstractDocumentsProxySessionCallback<List<ServiceEntry>> {
        Callback(ProxySession session) {
            super(session);
        }

        @Override
        public void completed(List<ServiceEntry> entries) {
            try {
                JsonType jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
                StringBuilderWriter sbw = new StringBuilderWriter();
                try (JsonWriter jw = jsonType.create(sbw)) {
                    jw.startObject();
                    jw.key("services");
                    jw.startArray();
                    for (ServiceEntry entry : entries) {
                        jw.value(entry);
                    }
                    jw.endArray();
                    jw.endObject();
                }
                session.response(
                        HttpStatus.SC_OK,
                        new StringEntity(sbw.toString(), ContentType.APPLICATION_JSON));
            } catch (IOException | BadRequestException ioe) {
                failed(ioe);
            }
        }
    }
}
