package ru.yandex.passport;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.passport.document.DocumentSourceService;

public class DocumentsContext {
    private final ProxySession session;
    private final long userId;
    private final DocumentSourceService service;

    public DocumentsContext(final ProxySession session, DocumentSourceService service) throws BadRequestException {
        this.session = session;
        this.userId = session.params().getLong("user_id");
        this.service = service;
    }

    public ProxySession session() {
        return session;
    }

    public long userId() {
        return userId;
    }

    public DocumentSourceService service() {
        return service;
    }
}
