package ru.yandex.passport;

import java.io.IOException;

import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import org.apache.http.HttpMessage;

import ru.yandex.blackbox.BlackboxClient;
import ru.yandex.client.tvm2.UserAuthResult;
import ru.yandex.collection.Pattern;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.passport.config.ImmutableDocumentsProxyConfig;
import ru.yandex.search.proxy.universal.UniversalSearchProxy;

public class DocumentsProxy extends UniversalSearchProxy<ImmutableDocumentsProxyConfig> {
    private final DocumentsStorage storage;
    private final AsyncClient avatarUploadClient;
    private final BlackboxClient blackboxClient;

    public DocumentsProxy(final ImmutableDocumentsProxyConfig config) throws IOException, ConfigException {
        super(config);
        this.storage = new LuceneDocumentsStorage(
                this,
                new SecretKeySpec(config.aesKey(), "AES"),
                new IvParameterSpec(config.aesIv())
        );
        this.avatarUploadClient = client("AvatarUpload", config.avatar().uploadConfig());
        this.blackboxClient = registerClient(
                        "Blackbox",
                        new BlackboxClient(reactor, config.blackbox()),
                        config.blackbox()
        );

        this.register(
                new Pattern<>("/document/add", false),
                new DocumentAddHandler(this)
        );
        this.register(
                new Pattern<>("/document/update", false),
                new DocumentUpdateHandler(this)
        );
        this.register(
                new Pattern<>("/document/image/upload", false),
                new DocumentImageUploadHandler(this)
        );
        this.register(
                new Pattern<>("/document/image/disk/copy", false),
                new DocumentImageDiskCopyHandler(this)
        );
        this.register(
                new Pattern<>("/document/image/check", false),
                new DocumentImageCheckHandler(this)
        );
        this.register(
                new Pattern<>("/document/get", false),
                new DocumentGetHandler(this)
        );
        this.register(
                new Pattern<>("/document/list", false),
                new DocumentListHandler(this)
        );
        this.register(
                new Pattern<>("/document/delete", false),
                new DocumentDeleteHandler(this)
        );
        this.register(
                new Pattern<>("/document/services", false),
                new DocumentServicesHandler(this)
        );
    }

    public DocumentsStorage storage() {
        return storage;
    }

    public AsyncClient avatarUploadClient() {
        return avatarUploadClient;
    }

    public BlackboxClient blackboxClient() {
        return blackboxClient;
    }

    public String blackboxTvm2Ticket() {
        return tvm2ClientTicketGenerator.ticket(config().blackboxTvmClientId());
    }

    public UserAuthResult checkTvmUserAuthorization(HttpMessage request) {
        return serviceContextRenewalTask.checkUserAuthorization(
                request,
                YandexHeaders.X_YA_USER_TICKET);
    }
}
