package ru.yandex.passport;

import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.passport.document.BaseDocumentBuilder;
import ru.yandex.passport.document.Document;
import ru.yandex.passport.document.DocumentSourceService;
import ru.yandex.passport.document.DocumentType;
import ru.yandex.passport.document.ServiceEntry;

public interface DocumentsStorage {
    void get(
            final ProxySession session,
            final Long userId,
            final String documentId,
            final String originalId,
            final FutureCallback<BaseDocumentBuilder> callback
    );

    void list(
        final ProxySession session,
        final Long userId,
        final DocumentType documentType,
        final DocumentSourceService service,
        final FutureCallback<List<? extends Document>> callback
    );

    void put(
            final ProxySession session,
            final Long userId,
            final BaseDocumentBuilder document,
            final FutureCallback<? super Document> callback
    );

    void update(
            final ProxySession session,
            final Long userId,
            final BaseDocumentBuilder document,
            final FutureCallback<? super Document> callback
    );

    void delete(
            final ProxySession session,
            final Long userId,
            final String documentId,
            final String originalId,
            final FutureCallback<Object> callback
    );

    void getServices(
            final ProxySession session,
            final Long userId,
            final DocumentType documentType,
            final FutureCallback<List<ServiceEntry>> callback
    );
}
