package ru.yandex.passport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.passport.document.DocumentSourceService;

public class RequestServiceResolver {
    private static final Map<String, DocumentSourceService> tvmMap;
    static {
        Map<String, DocumentSourceService> map = new HashMap<>();
        map.put("0", DocumentSourceService.TEST);
        map.put("2021183", DocumentSourceService.PASSPORT);
        map.put("2024245", DocumentSourceService.PASSPORT);
        map.put("2021181", DocumentSourceService.PASSPORT);
        map.put("2024247", DocumentSourceService.PASSPORT);
        map.put("2010646", DocumentSourceService.PASSPORT);
        map.put("2010644", DocumentSourceService.PASSPORT);
        map.put("2033601", DocumentSourceService.PASSPORT);
        map.put("2033365", DocumentSourceService.MARKET);
        map.put("2033367", DocumentSourceService.MARKET);
        map.put("2020751", DocumentSourceService.TRIP);
        map.put("2020755", DocumentSourceService.TRIP);
        tvmMap = Collections.unmodifiableMap(map);
    }

    public static DocumentSourceService resolve(final ProxySession session) throws BadRequestException {
        String serviceId = (String) session.context().getAttribute(HttpServer.SESSION_USER);
        if (serviceId == null) {
            serviceId = session.params().getString("request_service");
        } else {
            int index = serviceId.indexOf(':');
            if (index >= 0 && index < serviceId.length() - 1) {
                serviceId = serviceId.substring(index + 1);
            }
        }
        if (serviceId == null) {
            throw new BadRequestException("Cannot parse service id from request");
        }
        if (!tvmMap.containsKey(serviceId)) {
            throw new BadRequestException("Service is not registered for this API");
        }
        return tvmMap.get(serviceId);
    }
}
