package ru.yandex.passport.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractAvatarConfigBuilder
    <T extends AbstractAvatarConfigBuilder<T>>
     implements AvatarConfig
{
    private String namespace;
    private HttpHostConfigBuilder uploadConfig;
    private HttpHostConfigBuilder getConfig;

    AbstractAvatarConfigBuilder(final AvatarConfig config) {
        namespace(config.namespace());
        uploadConfig(config.uploadConfig());
        getConfig(config.getConfig());
    }

    AbstractAvatarConfigBuilder(
        final IniConfig config,
        final AvatarConfig defaults)
        throws ConfigException
    {
        this.namespace = config.getString("namespace", defaults.namespace());
        this.uploadConfig =
            new HttpHostConfigBuilder(
                config.section("upload"),
                defaults.uploadConfig());
        this.getConfig =
            new HttpHostConfigBuilder(
                config.section("retrieve"),
                defaults.getConfig());
    }

    @Override()
    public String namespace() {
        return namespace;
    }

    public T namespace(final String value) {
        this.namespace = value;
        return self();
    }

    @Override()
    public HttpHostConfigBuilder uploadConfig() {
        return uploadConfig;
    }

    public T uploadConfig(final HttpHostConfig value) {
        this.uploadConfig = new HttpHostConfigBuilder(
            value);
        return self();
    }

    @Override()
    public HttpHostConfigBuilder getConfig() {
        return getConfig;
    }

    public T getConfig(final HttpHostConfig value) {
        this.getConfig = new HttpHostConfigBuilder(
            value);
        return self();
    }

    protected abstract T self();
}
