package ru.yandex.passport.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;

public abstract class AbstractDocumentsProxyConfigBuilder
    <T extends AbstractDocumentsProxyConfigBuilder<T>>
     extends AbstractUniversalSearchProxyConfigBuilder<T>
     implements DocumentsProxyConfig
{
    private HttpHostConfigBuilder datasync;
    private HttpHostConfigBuilder disk;
    private AvatarConfigBuilder avatar;
    private HttpHostConfigBuilder blackbox;
    private String blackboxTvmClientId;
    private byte[] aesKey;
    private byte[] aesIv;


    protected AbstractDocumentsProxyConfigBuilder(final DocumentsProxyConfig config) {
        super(config);
        datasync(config.datasync());
        disk(config.disk());
        avatar(config.avatar());
        blackbox(config.blackbox());
        blackboxTvmClientId(config.blackboxTvmClientId());
        aesKey(config.aesKey());
        aesIv(config.aesIv());
    }

    protected AbstractDocumentsProxyConfigBuilder(
        final IniConfig config,
        final DocumentsProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.datasync =
            new HttpHostConfigBuilder(
                config.section("datasync"),
                defaults.datasync());
        this.disk =
            new HttpHostConfigBuilder(
                config.section("disk"),
                defaults.disk());
        this.avatar =
            new AvatarConfigBuilder(
                config.section("avatar"),
                defaults.avatar());
        this.blackbox =
                new HttpHostConfigBuilder(
                        config.section("blackbox"),
                        defaults.blackbox());
        this.blackboxTvmClientId = config.get(
                "blackbox.tvm-client-id",
                defaults.blackboxTvmClientId(),
                NonEmptyValidator.INSTANCE
        );
        this.aesKey = AES_KEY.extract(config, defaults.aesKey());
        this.aesIv = AES_IV.extract(config, defaults.aesKey());
    }

    @Override()
    public HttpHostConfigBuilder datasync() {
        return datasync;
    }

    public T datasync(final HttpHostConfig value) {
        this.datasync = new HttpHostConfigBuilder(
            value);
        return self();
    }

    @Override()
    public HttpHostConfigBuilder disk() {
        return disk;
    }

    public T disk(final HttpHostConfig value) {
        this.disk = new HttpHostConfigBuilder(
            value);
        return self();
    }

    @Override
    public AvatarConfigBuilder avatar() {
        return avatar;
    }

    public T avatar(final AvatarConfig avatar) {
        this.avatar = new AvatarConfigBuilder(avatar);
        return self();
    }

    @Override
    public HttpHostConfigBuilder blackbox() {
        return blackbox;
    }

    public T blackbox(final HttpHostConfig blackbox) {
        this.blackbox = new HttpHostConfigBuilder(blackbox);
        return self();
    }

    @Override
    public String blackboxTvmClientId() {
        return blackboxTvmClientId;
    }

    public T blackboxTvmClientId(final String blackboxTvmClientId) {
        this.blackboxTvmClientId = blackboxTvmClientId;
        return self();
    }

    @Override
    public byte[] aesKey() {
        return aesKey;
    }

    public T aesKey(final byte[] aesKey) {
        this.aesKey = aesKey;
        return self();
    }

    @Override
    public byte[] aesIv() {
        return aesIv;
    }

    public T aesIv(final byte[] aesIv) {
        this.aesIv = aesIv;
        return self();
    }
}
