package ru.yandex.passport.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class AvatarConfigBuilder
     extends AbstractAvatarConfigBuilder<AvatarConfigBuilder>
{
    public AvatarConfigBuilder() {
        this(AvatarConfigDefaults.INSTANCE);
    }

    public AvatarConfigBuilder(final AvatarConfig config) {
        super(config);
    }

    public AvatarConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, AvatarConfigDefaults.INSTANCE);
    }

    public AvatarConfigBuilder(
        final IniConfig config,
        final AvatarConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableAvatarConfig build() throws ConfigException {
        return new ImmutableAvatarConfig(
            this);
    }

    @Override
    protected AvatarConfigBuilder self() {
        return this;
    }
}
