package ru.yandex.passport.config;

import ru.yandex.base64.Base64Parser;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfig;

public interface DocumentsProxyConfig extends UniversalSearchProxyConfig {
    ParameterConfig<byte[]> AES_KEY =
            new ParameterConfig<>(
                    "storage.aes.key",
                    Base64Parser.INSTANCE,
                    byte[]::clone);

    ParameterConfig<byte[]> AES_IV =
            new ParameterConfig<>(
                    "storage.aes.iv",
                    Base64Parser.INSTANCE,
                    byte[]::clone);


    HttpHostConfig datasync();

    HttpHostConfig disk();

    AvatarConfig avatar();

    HttpHostConfig blackbox();

    String blackboxTvmClientId();

    byte[] aesKey();

    byte[] aesIv();
}
