package ru.yandex.passport.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class DocumentsProxyConfigBuilder
     extends AbstractDocumentsProxyConfigBuilder<DocumentsProxyConfigBuilder>
{
    public DocumentsProxyConfigBuilder() {
        this(DocumentsProxyConfigDefaults.INSTANCE);
    }

    public DocumentsProxyConfigBuilder(final DocumentsProxyConfig config) {
        super(config);
    }

    public DocumentsProxyConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, DocumentsProxyConfigDefaults.INSTANCE);
    }

    public DocumentsProxyConfigBuilder(
        final IniConfig config,
        final DocumentsProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableDocumentsProxyConfig build() throws ConfigException {
        return new ImmutableDocumentsProxyConfig(
            this);
    }

    @Override
    public DocumentsProxyConfigBuilder self() {
        return this;
    }
}
