package ru.yandex.passport.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableAvatarConfig
     implements AvatarConfig
{
    private final String namespace;
    private final ImmutableHttpHostConfig uploadConfig;
    private final ImmutableHttpHostConfig getConfig;

    public ImmutableAvatarConfig(
        final AvatarConfig config)
        throws ConfigException
    {
        this.namespace = config.namespace();
        this.uploadConfig = new ImmutableHttpHostConfig(
            config.uploadConfig());
        this.getConfig = new ImmutableHttpHostConfig(
            config.getConfig());
    }

    @Override
    public String namespace() {
        return namespace;
    }

    @Override
    public ImmutableHttpHostConfig uploadConfig() {
        return uploadConfig;
    }

    @Override
    public ImmutableHttpHostConfig getConfig() {
        return getConfig;
    }
}
