package ru.yandex.passport.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class ImmutableDocumentsProxyConfig
     extends ImmutableUniversalSearchProxyConfig
     implements DocumentsProxyConfig
{
    private final ImmutableHttpHostConfig datasync;
    private final ImmutableHttpHostConfig disk;
    private final ImmutableAvatarConfig avatar;
    private final ImmutableHttpHostConfig blackbox;
    private final String blackboxTvmClientId;
    private final byte[] aesKey;
    private final byte[] aesIv;

    public ImmutableDocumentsProxyConfig(
        final DocumentsProxyConfig config)
        throws ConfigException
    {
        super(config);
        this.datasync = new ImmutableHttpHostConfig(config.datasync());
        this.disk = new ImmutableHttpHostConfig(config.disk());
        this.avatar = new ImmutableAvatarConfig(config.avatar());
        this.blackbox = new ImmutableHttpHostConfig(config.blackbox());
        this.blackboxTvmClientId = config.blackboxTvmClientId();
        this.aesKey = config.aesKey();
        this.aesIv = config.aesIv();
    }

    @Override
    public ImmutableHttpHostConfig datasync() {
        return datasync;
    }

    @Override
    public ImmutableHttpHostConfig disk() {
        return disk;
    }

    @Override
    public ImmutableAvatarConfig avatar() {
        return avatar;
    }

    @Override
    public ImmutableHttpHostConfig blackbox() {
        return blackbox;
    }

    @Override
    public String blackboxTvmClientId() {
        return blackboxTvmClientId;
    }

    @Override
    public byte[] aesKey() {
        return aesKey;
    }

    @Override
    public byte[] aesIv() {
        return aesIv;
    }
}
