package ru.yandex.passport.document;

import java.io.IOException;
import java.time.LocalDate;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriterBase;

public class BirthCertificateBuilder extends BaseDocumentBuilder {
    private String series;
    private String firstName;
    private String lastName;
    private String middleName;
    private String fullName;
    private LocalDate birthDate;
    private String birthPlace;
    private String birthAkt;
    private String fatherFirstName;
    private String fatherLastName;
    private String fatherMiddleName;
    private String fullFatherName;
    private LocalDate fatherBirthDate;
    private String fatherCitizenship;
    private String fatherNationality;
    private String motherFirstName;
    private String motherLastName;
    private String motherMiddleName;
    private String fullMotherName;
    private LocalDate motherBirthDate;
    private String motherCitizenship;
    private String motherNationality;
    private String country;
    private String registrationPlace;
    private String issuePlace;
    private LocalDate issueDate;

    public String series() {
        return series;
    }

    public BirthCertificateBuilder series(String series) {
        this.series = series;
        return this;
    }

    public String firstName() {
        return firstName;
    }

    public BirthCertificateBuilder firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String lastName() {
        return lastName;
    }

    public BirthCertificateBuilder lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String middleName() {
        return middleName;
    }

    public BirthCertificateBuilder middleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    public String fullName() {
        return fullName;
    }

    public BirthCertificateBuilder fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public LocalDate birthDate() {
        return birthDate;
    }

    public BirthCertificateBuilder birthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
        return this;
    }

    public String birthPlace() {
        return birthPlace;
    }

    public BirthCertificateBuilder birthPlace(String birthPlace) {
        this.birthPlace = birthPlace;
        return this;
    }

    public String birthAkt() {
        return birthAkt;
    }

    public BirthCertificateBuilder birthAkt(String birthAkt) {
        this.birthAkt = birthAkt;
        return this;
    }

    public String fatherFirstName() {
        return fatherFirstName;
    }

    public BirthCertificateBuilder fatherFirstName(String fatherFirstName) {
        this.fatherFirstName = fatherFirstName;
        return this;
    }

    public String fatherLastName() {
        return fatherLastName;
    }

    public BirthCertificateBuilder fatherLastName(String fatherLastName) {
        this.fatherLastName = fatherLastName;
        return this;
    }

    public String fatherMiddleName() {
        return fatherMiddleName;
    }

    public BirthCertificateBuilder fatherMiddleName(String fatherMiddleName) {
        this.fatherMiddleName = fatherMiddleName;
        return this;
    }

    public String fullFatherName() {
        return fullFatherName;
    }

    public BirthCertificateBuilder fullFatherName(String fullFatherName) {
        this.fullFatherName = fullFatherName;
        return this;
    }

    public LocalDate fatherBirthDate() {
        return fatherBirthDate;
    }

    public BirthCertificateBuilder fatherBirthDate(LocalDate fatherBirthDate) {
        this.fatherBirthDate = fatherBirthDate;
        return this;
    }

    public String fatherCitizenship() {
        return fatherCitizenship;
    }

    public BirthCertificateBuilder fatherCitizenship(String fatherCitizenship) {
        this.fatherCitizenship = fatherCitizenship;
        return this;
    }

    public String fatherNationality() {
        return fatherNationality;
    }

    public BirthCertificateBuilder fatherNationality(String fatherNationality) {
        this.fatherNationality = fatherNationality;
        return this;
    }

    public String motherFirstName() {
        return motherFirstName;
    }

    public BirthCertificateBuilder motherFirstName(String motherFirstName) {
        this.motherFirstName = motherFirstName;
        return this;
    }

    public String motherLastName() {
        return motherLastName;
    }

    public BirthCertificateBuilder motherLastName(String motherLastName) {
        this.motherLastName = motherLastName;
        return this;
    }

    public String motherMiddleName() {
        return motherMiddleName;
    }

    public BirthCertificateBuilder motherMiddleName(String motherMiddleName) {
        this.motherMiddleName = motherMiddleName;
        return this;
    }

    public String fullMotherName() {
        return fullMotherName;
    }

    public BirthCertificateBuilder fullMotherName(String fullMotherName) {
        this.fullMotherName = fullMotherName;
        return this;
    }

    public LocalDate motherBirthDate() {
        return motherBirthDate;
    }

    public BirthCertificateBuilder motherBirthDate(LocalDate motherBirthDate) {
        this.motherBirthDate = motherBirthDate;
        return this;
    }

    public String motherCitizenship() {
        return motherCitizenship;
    }

    public BirthCertificateBuilder motherCitizenship(String motherCitizenship) {
        this.motherCitizenship = motherCitizenship;
        return this;
    }

    public String motherNationality() {
        return motherNationality;
    }

    public BirthCertificateBuilder motherNationality(String motherNationality) {
        this.motherNationality = motherNationality;
        return this;
    }

    public String country() {
        return country;
    }

    public BirthCertificateBuilder country(String country) {
        this.country = country;
        return this;
    }

    public String registrationPlace() {
        return registrationPlace;
    }

    public BirthCertificateBuilder registrationPlace(String registrationPlace) {
        this.registrationPlace = registrationPlace;
        return this;
    }

    public String issuePlace() {
        return issuePlace;
    }

    public BirthCertificateBuilder issuePlace(String issuePlace) {
        this.issuePlace = issuePlace;
        return this;
    }

    public LocalDate issueDate() {
        return issueDate;
    }

    public BirthCertificateBuilder issueDate(LocalDate issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    @Override
    public void writeFields(JsonWriterBase writer) throws IOException {
        super.writeFields(writer);
        writer.key("series");
        writer.value(series());
        writer.key("first_name");
        writer.value(firstName());
        writer.key("last_name");
        writer.value(lastName());
        writer.key("middle_name");
        writer.value(middleName());
        writer.key("full_name");
        writer.value(fullName());
        writer.key("birth_date");
        writer.value(birthDate());
        writer.key("birth_place");
        writer.value(birthPlace());
        writer.key("birth_akt");
        writer.value(birthAkt());
        writer.key("father_first_name");
        writer.value(fatherFirstName());
        writer.key("father_last_name");
        writer.value(fatherLastName());
        writer.key("father_middle_name");
        writer.value(fatherMiddleName());
        writer.key("full_father_name");
        writer.value(fullFatherName());
        writer.key("father_birth_date");
        writer.value(fatherBirthDate());
        writer.key("father_citizenship");
        writer.value(fatherCitizenship());
        writer.key("father_nationality");
        writer.value(fatherNationality());
        writer.key("mother_first_name");
        writer.value(motherFirstName());
        writer.key("mother_last_name");
        writer.value(motherLastName());
        writer.key("mother_middle_name");
        writer.value(motherMiddleName());
        writer.key("full_mother_name");
        writer.value(fullMotherName());
        writer.key("mother_birth_date");
        writer.value(motherBirthDate());
        writer.key("mother_citizenship");
        writer.value(motherCitizenship());
        writer.key("mother_nationality");
        writer.value(motherNationality());
        writer.key("country");
        writer.value(country());
        writer.key("registration_place");
        writer.value(registrationPlace());
        writer.key("issue_place");
        writer.value(issuePlace());
        writer.key("issue_date");
        writer.value(issueDate());
    }

    @Override
    public BirthCertificateBuilder parse(JsonMap map) throws JsonException {
        super.parse(map);
        this.series(map.getString("series", null));
        this.firstName(map.getString("first_name", null));
        this.lastName(map.getString("last_name", null));
        this.middleName(map.getString("middle_name", null));
        this.fullName(map.getString("full_name", null));
        this.birthDate(map.get("birth_date", null, this::parseLocalDate));
        this.birthPlace(map.getString("birth_place", null));
        this.birthAkt(map.getString("birth_akt", null));
        this.fatherFirstName(map.getString("father_first_name", null));
        this.fatherLastName(map.getString("father_last_name", null));
        this.fatherMiddleName(map.getString("father_middle_name", null));
        this.fullFatherName(map.getString("full_father_name", null));
        this.fatherBirthDate(map.get("father_birth_date", null, this::parseLocalDate));
        this.fatherCitizenship(map.getString("father_citizenship", null));
        this.fatherNationality(map.getString("father_nationality", null));
        this.motherFirstName(map.getString("mother_first_name", null));
        this.motherLastName(map.getString("mother_last_name", null));
        this.motherMiddleName(map.getString("mother_middle_name", null));
        this.fullMotherName(map.getString("full_mother_name", null));
        this.motherBirthDate(map.get("mother_birth_date", null, this::parseLocalDate));
        this.motherCitizenship(map.getString("mother_citizenship", null));
        this.motherNationality(map.getString("mother_nationality", null));
        this.country(map.getString("country", null));
        this.registrationPlace(map.getString("registration_place", null));
        this.issuePlace(map.getString("issue_place", null));
        this.issueDate(map.get("issue_date", null, this::parseLocalDate));
        return this;
    }

}
