package ru.yandex.passport.document;

import java.io.IOException;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public interface Document extends JsonValue {
    String id();

    DocumentType docType();

    static BaseDocumentBuilder parse(final JsonMap mapObj) throws JsonException {
        DocumentType documentType = mapObj.getEnum(DocumentType.class, "doc_type");
        return documentType.builder().parse(mapObj);
    }

    void writeFields(final JsonWriterBase writer) throws IOException;

    @Override
    default void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writeFields(writer);
        writer.endObject();
    }
}
