package ru.yandex.passport.document;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum DocumentSourceService {
    DRIVE("drive"),
    PASSPORT("passport"),
    MARKET("market"),
    TRIP("trip"),

    TEST("test"), // for testing only; do not use in prod
    ;
    private final String value;

    private static final Map<String, DocumentSourceService> map =
            Arrays.stream(DocumentSourceService.values())
                    .collect(Collectors.toMap(DocumentSourceService::value, Function.identity()));

    DocumentSourceService(String value) {
        this.value = value;
    }

    public String value() {
        return value;
    }

    public static DocumentSourceService of(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Service is null");
        }
        DocumentSourceService result = map.get(value);
        if (result == null) {
            throw new IllegalArgumentException("Unknown service: " + value);
        }
        return result;
    }
}
