package ru.yandex.passport.document;

import java.util.function.Supplier;

public enum DocumentType {
    NATIONAL_ID(NationalIdBuilder::new),
    INTERNATIONAL_ID(InternationalIdBuilder::new),
    DRIVER_LICENSE(DriverLicenseBuilder::new),
    BIRTH_CERTIFICATE(BirthCertificateBuilder::new),
    MEDICAL_INSURANCE(MedicalInsuranceBuilder::new),
    // RUSSIAN docs
    SNILS(SnilsBuilder::new),
    INN(InnBuilder::new),
    VOLUNTARY_MEDICAL_INSURANCE(VoluntaryMedicalInsuranceBuilder::new),
    VEHICLE_REGISTRATION_CERTIFICATE(VehicleRegistrationCertificateBuilder::new),
    ;

    private final Supplier<? extends BaseDocumentBuilder> documentBuilderSupplier;

    DocumentType(Supplier<? extends BaseDocumentBuilder> documentBuilderSupplier) {
        this.documentBuilderSupplier = documentBuilderSupplier;
    }

    public BaseDocumentBuilder builder() {
        return documentBuilderSupplier.get();
    }
}
