package ru.yandex.passport.document;

import java.io.IOException;
import java.time.LocalDate;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriterBase;

public class DriverLicenseBuilder extends BaseDocumentBuilder {
    private String firstName;
    private String lastName;
    private String middleName;
    private String fullName;
    private String firstNameLat;
    private String lastNameLat;
    private String middleNameLat;
    private String fullNameLat;
    private String birthPlace;
    private String birthPlaceLat;
    private LocalDate birthDate;
    private LocalDate issueDate;
    private LocalDate endDate;
    private String issuedBy;
    private String issuedByLat;
    private String issuedCity;
    private String issuedCityLat;
    private String category;
    private String additionalInformation;

    public String firstName() {
        return firstName;
    }

    public DriverLicenseBuilder firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String lastName() {
        return lastName;
    }

    public DriverLicenseBuilder lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String middleName() {
        return middleName;
    }

    public DriverLicenseBuilder middleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    public String fullName() {
        return fullName;
    }

    public DriverLicenseBuilder fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public String firstNameLat() {
        return firstNameLat;
    }

    public DriverLicenseBuilder firstNameLat(String firstNameLat) {
        this.firstNameLat = firstNameLat;
        return this;
    }

    public String lastNameLat() {
        return lastNameLat;
    }

    public DriverLicenseBuilder lastNameLat(String lastNameLat) {
        this.lastNameLat = lastNameLat;
        return this;
    }

    public String middleNameLat() {
        return middleNameLat;
    }

    public DriverLicenseBuilder middleNameLat(String middleNameLat) {
        this.middleNameLat = middleNameLat;
        return this;
    }

    public String fullNameLat() {
        return fullNameLat;
    }

    public DriverLicenseBuilder fullNameLat(String fullNameLat) {
        this.fullNameLat = fullNameLat;
        return this;
    }

    public String birthPlace() {
        return birthPlace;
    }

    public DriverLicenseBuilder birthPlace(String birthPlace) {
        this.birthPlace = birthPlace;
        return this;
    }

    public String birthPlaceLat() {
        return birthPlaceLat;
    }

    public DriverLicenseBuilder birthPlaceLat(String birthPlaceLat) {
        this.birthPlaceLat = birthPlaceLat;
        return this;
    }

    public LocalDate birthDate() {
        return birthDate;
    }

    public DriverLicenseBuilder birthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
        return this;
    }

    public LocalDate issueDate() {
        return issueDate;
    }

    public DriverLicenseBuilder issueDate(LocalDate issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    public LocalDate endDate() {
        return endDate;
    }

    public DriverLicenseBuilder endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    public String issuedBy() {
        return issuedBy;
    }

    public DriverLicenseBuilder issuedBy(String issuedBy) {
        this.issuedBy = issuedBy;
        return this;
    }

    public String issuedByLat() {
        return issuedByLat;
    }

    public DriverLicenseBuilder issuedByLat(String issuedByLat) {
        this.issuedByLat = issuedByLat;
        return this;
    }

    public String issuedCity() {
        return issuedCity;
    }

    public DriverLicenseBuilder issuedCity(String issuedCity) {
        this.issuedCity = issuedCity;
        return this;
    }

    public String issuedCityLat() {
        return issuedCityLat;
    }

    public DriverLicenseBuilder issuedCityLat(String issuedCityLat) {
        this.issuedCityLat = issuedCityLat;
        return this;
    }

    public String category() {
        return category;
    }

    public DriverLicenseBuilder category(String category) {
        this.category = category;
        return this;
    }

    public String additionalInformation() {
        return additionalInformation;
    }

    public DriverLicenseBuilder additionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    @Override
    public void writeFields(JsonWriterBase writer) throws IOException {
        super.writeFields(writer);
        writer.key("first_name");
        writer.value(firstName());
        writer.key("last_name");
        writer.value(lastName());
        writer.key("middle_name");
        writer.value(middleName());
        writer.key("full_name");
        writer.value(fullName());
        writer.key("first_name_lat");
        writer.value(firstNameLat());
        writer.key("last_name_lat");
        writer.value(lastNameLat());
        writer.key("middle_name_lat");
        writer.value(middleNameLat());
        writer.key("full_name_lat");
        writer.value(fullNameLat());
        writer.key("birth_place");
        writer.value(birthPlace());
        writer.key("birth_place_lat");
        writer.value(birthPlaceLat());
        writer.key("birth_date");
        writer.value(birthDate());
        writer.key("issue_date");
        writer.value(issueDate());
        writer.key("end_date");
        writer.value(endDate());
        writer.key("issued_by");
        writer.value(issuedBy());
        writer.key("issued_by_lat");
        writer.value(issuedByLat());
        writer.key("issued_city");
        writer.value(issuedCity());
        writer.key("issued_city_lat");
        writer.value(issuedCityLat());
        writer.key("category");
        writer.value(category());
        writer.key("additional_information");
        writer.value(additionalInformation());
    }

    @Override
    public DriverLicenseBuilder parse(JsonMap map) throws JsonException {
        super.parse(map);
        this.firstName(map.getString("first_name", null));
        this.lastName(map.getString("last_name", null));
        this.middleName(map.getString("middle_name", null));
        this.fullName(map.getString("full_name", null));
        this.firstNameLat(map.getString("first_name_lat", null));
        this.lastNameLat(map.getString("last_name_lat", null));
        this.middleNameLat(map.getString("middle_name_lat", null));
        this.fullNameLat(map.getString("full_name_lat", null));
        this.birthPlace(map.getString("birth_place", null));
        this.birthPlaceLat(map.getString("birth_place_lat", null));
        this.birthDate(map.get("birth_date", null, this::parseLocalDate));
        this.issueDate(map.get("issue_date", null, this::parseLocalDate));
        this.endDate(map.get("end_date", null, this::parseLocalDate));
        this.issuedBy(map.getString("issued_by", null));
        this.issuedByLat(map.getString("issued_by_lat", null));
        this.issuedCity(map.getString("issued_city", null));
        this.issuedCityLat(map.getString("issued_city_lat", null));
        this.category(map.getString("category", null));
        this.additionalInformation(map.getString("additional_information", null));
        return this;
    }
}
