package ru.yandex.passport.document;

import java.io.IOException;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.passport.config.AvatarConfig;

public class ImageBuilder implements JsonValue {
    private String imageId;
    private String originalUri;
    private String originalUrl;
    private Integer originalWidth;
    private Integer originalHeight;
    private String previewUri;
    private String previewUrl;
    private Integer previewWidth;
    private Integer previewHeight;

    public String imageId() {
        return imageId;
    }

    public ImageBuilder imageId(final String imageId) {
        this.imageId = imageId;
        return this;
    }

    public String originalUri() {
        return originalUri;
    }

    public ImageBuilder originalUri(final String originalUri) {
        this.originalUri = originalUri;
        return this;
    }

    public String previewUri() {
        return previewUri;
    }

    public ImageBuilder previewUri(final String previewUri) {
        this.previewUri = previewUri;
        return this;
    }

    public Integer originalWidth() {
        return originalWidth;
    }

    public ImageBuilder originalWidth(final Integer originalWidth) {
        this.originalWidth = originalWidth;
        return this;
    }

    public Integer originalHeight() {
        return originalHeight;
    }

    public ImageBuilder originalHeight(final Integer originalHeight) {
        this.originalHeight = originalHeight;
        return this;
    }

    public Integer previewWidth() {
        return previewWidth;
    }

    public ImageBuilder previewWidth(final Integer previewWidth) {
        this.previewWidth = previewWidth;
        return this;
    }

    public Integer previewHeight() {
        return previewHeight;
    }

    public ImageBuilder previewHeight(final Integer previewHeight) {
        this.previewHeight = previewHeight;
        return this;
    }

    public String originalUrl() {
        return originalUrl;
    }

    public ImageBuilder originalUrl(final String originalUrl) {
        this.originalUrl = originalUrl;
        return this;
    }

    public String previewUrl() {
        return previewUrl;
    }

    public ImageBuilder previewUrl(final String previewUrl) {
        this.previewUrl = previewUrl;
        return this;
    }

    public void generateRetrieveUrls(final AvatarConfig config) {
        if (this.originalUri() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(config.getConfig().host().getSchemeName());
            sb.append("://");
            sb.append(config.getConfig().host().getHostName());
            sb.append(this.originalUri);
            // front not working without port
            this.originalUrl = sb.toString();
        }

        if (this.previewUri() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(config.getConfig().host().getSchemeName());
            sb.append("://");
            sb.append(config.getConfig().host().getHostName());
            sb.append(this.previewUri);
            // front not working without port
            this.previewUrl = sb.toString();
        }
    }

    public ImageBuilder fillAvatar(final JsonMap map, final AvatarConfig config) throws JsonException {
        String imagename = map.getString("imagename");
        String groupId = map.getString("group-id");
        JsonMap sizes = map.getMap("sizes");
        JsonMap original = sizes.getMap("orig");
        String origPath = original.getString("path");
        int origWidth = original.getInt("width");
        int origHeight = original.getInt("height");
        JsonMap preview = sizes.getMapOrNull("optimize");
        if (preview == null) {
            preview = original;
        }
        String previewPath = preview.getString("path");
        int previewWidth = preview.getInt("width");
        int previewHeight = preview.getInt("height");
        this.imageId(groupId + '/' + imagename);
        this.originalUri(origPath);
        this.originalWidth(origWidth);
        this.originalHeight(origHeight);
        this.previewWidth(previewWidth);
        this.previewHeight(previewHeight);
        this.previewUri(previewPath);
        if (config != null) {
            this.generateRetrieveUrls(config);
        }
        return this;
    }

    public static ImageBuilder parse(JsonMap map) throws JsonException {
        ImageBuilder builder = new ImageBuilder();
        builder.imageId(map.getString("image_id", null));
        builder.originalUri(map.getString("original_uri", null));
        builder.previewUri(map.getString("preview_uri", null));
        builder.originalWidth(map.getInt("original_width", null));
        builder.originalHeight(map.getInt("original_height", null));
        builder.previewWidth(map.getInt("preview_width", null));
        builder.previewHeight(map.getInt("preview_height", null));
        return builder;
    }

    @Override
    public void writeValue(JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("image_id");
        writer.value(imageId());
        writer.key("original_uri");
        writer.value(originalUri());
        writer.key("original_width");
        writer.value(originalWidth());
        writer.key("original_height");
        writer.value(originalHeight());
        writer.key("preview_uri");
        writer.value(previewUri());
        if (previewUrl != null) {
            writer.key("preview_url");
            writer.value(previewUrl);
        }
        if (originalUrl != null) {
            writer.key("original_url");
            writer.value(originalUrl);
        }
        writer.key("preview_width");
        writer.value(previewWidth());
        writer.key("preview_height");
        writer.value(previewHeight());
        writer.endObject();
    }
}
