package ru.yandex.passport.document;

import java.io.IOException;
import java.time.LocalDate;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriterBase;

public class InternationalIdBuilder extends BaseDocumentBuilder {
    private String firstName;
    private String lastName;
    private String middleName;
    private String fullName;
    private String firstNameLat;
    private String lastNameLat;
    private String middleNameLat;
    private String fullNameLat;
    private String birthPlace;
    private String birthPlaceLat;
    private LocalDate birthDate;
    private String codeOfIssuingState;
    private Gender gender;
    private LocalDate issueDate;
    private LocalDate endDate;
    private String issuedBy;
    private String citizenship;
    private String citizenshipLat;

    public String firstName() {
        return firstName;
    }

    public InternationalIdBuilder firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String lastName() {
        return lastName;
    }

    public InternationalIdBuilder lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String middleName() {
        return middleName;
    }

    public InternationalIdBuilder middleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    public String fullName() {
        return fullName;
    }

    public InternationalIdBuilder fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public String firstNameLat() {
        return firstNameLat;
    }

    public InternationalIdBuilder firstNameLat(String firstNameLat) {
        this.firstNameLat = firstNameLat;
        return this;
    }

    public String lastNameLat() {
        return lastNameLat;
    }

    public InternationalIdBuilder lastNameLat(String lastNameLat) {
        this.lastNameLat = lastNameLat;
        return this;
    }

    public String middleNameLat() {
        return middleNameLat;
    }

    public InternationalIdBuilder middleNameLat(String middleNameLat) {
        this.middleNameLat = middleNameLat;
        return this;
    }

    public String fullNameLat() {
        return fullNameLat;
    }

    public InternationalIdBuilder fullNameLat(String fullNameLat) {
        this.fullNameLat = fullNameLat;
        return this;
    }

    public String birthPlace() {
        return birthPlace;
    }

    public InternationalIdBuilder birthPlace(String birthPlace) {
        this.birthPlace = birthPlace;
        return this;
    }

    public String birthPlaceLat() {
        return birthPlaceLat;
    }

    public InternationalIdBuilder birthPlaceLat(String birthPlaceLat) {
        this.birthPlaceLat = birthPlaceLat;
        return this;
    }

    public LocalDate birthDate() {
        return birthDate;
    }

    public InternationalIdBuilder birthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
        return this;
    }

    public String codeOfIssuingState() {
        return codeOfIssuingState;
    }

    public InternationalIdBuilder codeOfIssuingState(String codeOfIssuingState) {
        this.codeOfIssuingState = codeOfIssuingState;
        return this;
    }

    public Gender gender() {
        return gender;
    }

    public InternationalIdBuilder gender(Gender gender) {
        this.gender = gender;
        return this;
    }

    public LocalDate issueDate() {
        return issueDate;
    }

    public InternationalIdBuilder issueDate(LocalDate issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    public LocalDate endDate() {
        return endDate;
    }

    public InternationalIdBuilder endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    public String issuedBy() {
        return issuedBy;
    }

    public InternationalIdBuilder issuedBy(String issuedBy) {
        this.issuedBy = issuedBy;
        return this;
    }

    public String citizenship() {
        return citizenship;
    }

    public InternationalIdBuilder citizenship(String citizenship) {
        this.citizenship = citizenship;
        return this;
    }

    public String citizenshipLat() {
        return citizenshipLat;
    }

    public InternationalIdBuilder citizenshipLat(String citizenshipLat) {
        this.citizenshipLat = citizenshipLat;
        return this;
    }

    @Override
    public void writeFields(JsonWriterBase writer) throws IOException {
        super.writeFields(writer);
        writer.key("first_name");
        writer.value(firstName());
        writer.key("last_name");
        writer.value(lastName());
        writer.key("middle_name");
        writer.value(middleName());
        writer.key("full_name");
        writer.value(fullName());
        writer.key("first_name_lat");
        writer.value(firstNameLat());
        writer.key("last_name_lat");
        writer.value(lastNameLat());
        writer.key("middle_name_lat");
        writer.value(middleNameLat());
        writer.key("full_name_lat");
        writer.value(fullNameLat());
        writer.key("birth_place");
        writer.value(birthPlace());
        writer.key("birth_place_lat");
        writer.value(birthPlaceLat());
        writer.key("birth_date");
        writer.value(birthDate());
        writer.key("gender");
        writer.value(gender());
        writer.key("issue_date");
        writer.value(issueDate());
        writer.key("end_date");
        writer.value(endDate());
        writer.key("code_of_issuing_state");
        writer.value(codeOfIssuingState());
        writer.key("issued_by");
        writer.value(issuedBy());
        writer.key("citizenship");
        writer.value(citizenship());
        writer.key("citizenship_lat");
        writer.value(citizenshipLat());
    }

    @Override
    public InternationalIdBuilder parse(JsonMap map) throws JsonException {
        super.parse(map);
        this.firstName(map.getString("first_name", null));
        this.lastName(map.getString("last_name", null));
        this.middleName(map.getString("middle_name", null));
        this.fullName(map.getString("full_name", null));
        this.firstNameLat(map.getString("first_name_lat", null));
        this.lastNameLat(map.getString("last_name_lat", null));
        this.middleNameLat(map.getString("middle_name_lat", null));
        this.fullNameLat(map.getString("full_name_lat", null));
        this.birthPlace(map.getString("birth_place", null));
        this.birthPlaceLat(map.getString("birth_place_lat", null));
        this.birthDate(map.get("birth_date", null, this::parseLocalDate));
        this.codeOfIssuingState(map.getString("code_of_issuing_state", null));
        this.gender(map.getEnum(Gender.class, "gender", null));
        this.issueDate(map.get("issue_date", null, this::parseLocalDate));
        this.endDate(map.get("end_date", null, this::parseLocalDate));
        this.issuedBy(map.getString("issued_by", null));
        this.citizenship(map.getString("citizenship", null));
        this.citizenshipLat(map.getString("citizenship_lat", null));
        return this;
    }
}

