package ru.yandex.passport.document;

import java.io.IOException;
import java.time.LocalDate;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriterBase;

public class MedicalInsuranceBuilder extends BaseDocumentBuilder {
    private String blank;
    private String firstName;
    private String lastName;
    private String middleName;
    private String fullName;
    private LocalDate birthDate;
    private Gender gender;

    public String blank() {
        return blank;
    }

    public MedicalInsuranceBuilder blank(String blank) {
        this.blank = blank;
        return this;
    }

    public String firstName() {
        return firstName;
    }

    public MedicalInsuranceBuilder firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String lastName() {
        return lastName;
    }

    public MedicalInsuranceBuilder lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String middleName() {
        return middleName;
    }

    public MedicalInsuranceBuilder middleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    public String fullName() {
        return fullName;
    }

    public MedicalInsuranceBuilder fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public LocalDate birthDate() {
        return birthDate;
    }

    public MedicalInsuranceBuilder birthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
        return this;
    }

    public Gender gender() {
        return gender;
    }

    public MedicalInsuranceBuilder gender(Gender gender) {
        this.gender = gender;
        return this;
    }

    @Override
    public void writeFields(JsonWriterBase writer) throws IOException {
        super.writeFields(writer);
        writer.key("blank");
        writer.value(blank());
        writer.key("first_name");
        writer.value(firstName());
        writer.key("last_name");
        writer.value(lastName());
        writer.key("middle_name");
        writer.value(middleName());
        writer.key("full_name");
        writer.value(fullName());
        writer.key("birth_date");
        writer.value(birthDate());
        writer.key("gender");
        writer.value(gender());
    }

    @Override
    public MedicalInsuranceBuilder parse(JsonMap map) throws JsonException {
        super.parse(map);
        this.blank(map.getString("blank", null));
        this.firstName(map.getString("first_name", null));
        this.lastName(map.getString("last_name", null));
        this.middleName(map.getString("middle_name", null));
        this.fullName(map.getString("full_name", null));
        this.birthDate(map.get("birth_date", null, this::parseLocalDate));
        this.gender(map.getEnum(Gender.class, "gender", null));
        return this;
    }
}
