package ru.yandex.passport.document;

import java.io.IOException;
import java.time.LocalDate;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriterBase;

public class NationalIdBuilder extends BaseDocumentBuilder {
    private String firstName;
    private String lastName;
    private String middleName;
    private String fullName;
    private String birthPlace;
    private LocalDate birthDate;
    private String country;
    private Gender gender;
    private LocalDate issueDate;
    private String issuedBy;
    // add verification (?)
    private String issuerSubdivisionCode;
    private String registrationRegion;
    private String registrationOrg;
    private String registrationOrgCode;
    private LocalDate registrationDate;
    private String registrationLocality;
    private String registrationStreet;
    private String registrationHouse;
    private String registrationHousing;
    private String registrationApartement;
    private String registrationAddressLine;

    public NationalIdBuilder() {
        super();
    }

    public String firstName() {
        return firstName;
    }

    public NationalIdBuilder firstName(final String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String lastName() {
        return lastName;
    }

    public NationalIdBuilder lastName(final String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String middleName() {
        return middleName;
    }

    public NationalIdBuilder middleName(final String middleName) {
        this.middleName = middleName;
        return this;
    }

    public String fullName() {
        return fullName;
    }

    public NationalIdBuilder fullName(final String fullName) {
        this.fullName = fullName;
        return this;
    }

    public String birthPlace() {
        return birthPlace;
    }

    public NationalIdBuilder birthPlace(final String birthPlace) {
        this.birthPlace = birthPlace;
        return this;
    }

    public LocalDate birthDate() {
        return birthDate;
    }

    public NationalIdBuilder birthDate(final LocalDate birthDate) {
        this.birthDate = birthDate;
        return this;
    }

    public String country() {
        return country;
    }

    public NationalIdBuilder country(final String country) {
        this.country = country;
        return this;
    }

    public Gender gender() {
        return gender;
    }

    public NationalIdBuilder gender(final Gender gender) {
        this.gender = gender;
        return this;
    }

    public LocalDate issueDate() {
        return issueDate;
    }

    public NationalIdBuilder issueDate(final LocalDate issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    public String issuedBy() {
        return issuedBy;
    }

    public NationalIdBuilder issuedBy(final String issuedBy) {
        this.issuedBy = issuedBy;
        return this;
    }

    public String issuerSubdivisionCode() {
        return issuerSubdivisionCode;
    }

    public NationalIdBuilder issuerSubdivisionCode(final String issuerSubdivisionCode) {
        this.issuerSubdivisionCode = issuerSubdivisionCode;
        return this;
    }

    public String registrationRegion() {
        return registrationRegion;
    }

    public NationalIdBuilder registrationRegion(final String registrationRegion) {
        this.registrationRegion = registrationRegion;
        return this;
    }

    public String registrationOrg() {
        return registrationOrg;
    }

    public NationalIdBuilder registrationOrg(final String registrationOrg) {
        this.registrationOrg = registrationOrg;
        return this;
    }

    public String registrationOrgCode() {
        return registrationOrgCode;
    }

    public NationalIdBuilder registrationOrgCode(final String registrationOrgCode) {
        this.registrationOrgCode = registrationOrgCode;
        return this;
    }

    public LocalDate registrationDate() {
        return registrationDate;
    }

    public NationalIdBuilder registrationDate(final LocalDate registrationDate) {
        this.registrationDate = registrationDate;
        return this;
    }

    public String registrationLocality() {
        return registrationLocality;
    }

    public NationalIdBuilder registrationLocality(final String registrationLocality) {
        this.registrationLocality = registrationLocality;
        return this;
    }

    public String registrationStreet() {
        return registrationStreet;
    }

    public NationalIdBuilder registrationStreet(final String registrationStreet) {
        this.registrationStreet = registrationStreet;
        return this;
    }

    public String registrationHouse() {
        return registrationHouse;
    }

    public NationalIdBuilder registrationHouse(final String registrationHouse) {
        this.registrationHouse = registrationHouse;
        return this;
    }

    public String registrationHousing() {
        return registrationHousing;
    }

    public NationalIdBuilder registrationHousing(final String registrationHousing) {
        this.registrationHousing = registrationHousing;
        return this;
    }

    public String registrationApartement() {
        return registrationApartement;
    }

    public NationalIdBuilder registrationApartement(final String registrationApartement) {
        this.registrationApartement = registrationApartement;
        return this;
    }

    public String registrationAddressLine() {
        return registrationAddressLine;
    }

    public NationalIdBuilder registrationAddressLine(final String registrationAddressLine) {
        this.registrationAddressLine = registrationAddressLine;
        return this;
    }

    @Override
    public void writeFields(final JsonWriterBase writer) throws IOException {
        super.writeFields(writer);
        writer.key("first_name");
        writer.value(firstName());
        writer.key("last_name");
        writer.value(lastName());
        writer.key("middle_name");
        writer.value(middleName());
        writer.key("full_name");
        writer.value(fullName());
        writer.key("birth_place");
        writer.value(birthPlace());
        writer.key("birth_date");
        writer.value(birthDate());
        writer.key("country");
        writer.value(country());
        writer.key("gender");
        writer.value(gender());
        writer.key("issue_date");
        writer.value(issueDate());
        writer.key("issued_by");
        writer.value(issuedBy());
        writer.key("issuer_subdivision_code");
        writer.value(issuerSubdivisionCode());
        writer.key("registration_region");
        writer.value(registrationRegion());
        writer.key("registration_org");
        writer.value(registrationOrg());
        writer.key("registration_date");
        writer.value(registrationDate());
        writer.key("registration_locality");
        writer.value(registrationLocality());
        writer.key("registration_street");
        writer.value(registrationStreet());
        writer.key("registration_house");
        writer.value(registrationHouse());
        writer.key("registration_housing");
        writer.value(registrationHousing());
        writer.key("registration_apartment");
        writer.value(registrationApartement());
        writer.key("registration_address_line");
        writer.value(registrationAddressLine());
    }

    @Override
    public NationalIdBuilder parse(JsonMap map) throws JsonException {
        super.parse(map);
        this.firstName(map.getString("first_name", null));
        this.lastName(map.getString("last_name", null));
        this.middleName(map.getString("middle_name", null));
        this.fullName(map.getString("full_name", null));
        this.birthPlace(map.getString("birth_place", null));
        this.birthDate(map.get("birth_date", null, this::parseLocalDate));
        this.country(map.getString("country", null));
        this.gender(map.getEnum(Gender.class, "gender", null));
        this.issueDate(map.get("issue_date", null, this::parseLocalDate));
        this.issuedBy(map.getString("issued_by", null));
        this.issuerSubdivisionCode(map.getString("issuer_subdivision_code", null));
        this.registrationOrg(map.getString("registration_org", null));
        this.registrationDate(map.get("registration_date", null, this::parseLocalDate));
        this.registrationLocality(map.getString("registration_locality", null));
        this.registrationStreet(map.getString("registration_street", null));
        this.registrationHouse(map.getString("registration_house", null));
        this.registrationHousing(map.getString("registration_housing", null));
        this.registrationApartement(map.getString("registration_apartment", null));
        this.registrationAddressLine(map.getString("registration_address_line", null));
        return this;
    }
}
