package ru.yandex.passport.document;

import java.io.IOException;
import java.util.Locale;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class ServiceEntry implements JsonValue {
    private final DocumentSourceService service;
    private final DocumentType documentType;

    public ServiceEntry(DocumentSourceService service, DocumentType documentType) {
        this.service = service;
        this.documentType = documentType;
    }

    @Override
    public void writeValue(JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("service_name");
        writer.value(service.value());
        writer.key("doc_type");
        writer.value(documentType.name().toLowerCase(Locale.ENGLISH));
        writer.endObject();
    }
}
