package ru.yandex.passport.document;

import java.io.IOException;
import java.time.LocalDate;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriterBase;

public class SnilsBuilder extends BaseDocumentBuilder {
    private String firstName;
    private String lastName;
    private String middleName;
    private String fullName;
    private String birthPlace;
    private LocalDate birthDate;
    private Gender gender;
    private LocalDate issueDate;

    public String firstName() {
        return firstName;
    }

    public SnilsBuilder firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String lastName() {
        return lastName;
    }

    public SnilsBuilder lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String middleName() {
        return middleName;
    }

    public SnilsBuilder middleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    public String fullName() {
        return fullName;
    }

    public SnilsBuilder fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public String birthPlace() {
        return birthPlace;
    }

    public SnilsBuilder birthPlace(String birthPlace) {
        this.birthPlace = birthPlace;
        return this;
    }

    public LocalDate birthDate() {
        return birthDate;
    }

    public SnilsBuilder birthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
        return this;
    }

    public Gender gender() {
        return gender;
    }

    public SnilsBuilder gender(Gender gender) {
        this.gender = gender;
        return this;
    }

    public LocalDate issueDate() {
        return issueDate;
    }

    public SnilsBuilder issueDate(LocalDate issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    @Override
    public void writeFields(JsonWriterBase writer) throws IOException {
        super.writeFields(writer);
        writer.key("first_name");
        writer.value(firstName());
        writer.key("last_name");
        writer.value(lastName());
        writer.key("middle_name");
        writer.value(middleName());
        writer.key("full_name");
        writer.value(fullName());
        writer.key("birth_place");
        writer.value(birthPlace());
        writer.key("birth_date");
        writer.value(birthDate());
        writer.key("gender");
        writer.value(gender());
        writer.key("issue_date");
        writer.value(issueDate());
    }

    @Override
    public SnilsBuilder parse(JsonMap map) throws JsonException {
        super.parse(map);
        this.firstName(map.getString("first_name", null));
        this.lastName(map.getString("last_name", null));
        this.middleName(map.getString("middle_name", null));
        this.fullName(map.getString("full_name", null));
        this.birthPlace(map.getString("birth_place", null));
        this.birthDate(map.get("birth_date", null, this::parseLocalDate));
        this.gender(map.getEnum(Gender.class, "gender", null));
        this.issueDate(map.get("issue_date", null, this::parseLocalDate));
        return this;
    }
}
