package ru.yandex.passport.document;

import java.io.IOException;
import java.time.LocalDate;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriterBase;

public class VehicleRegistrationCertificateBuilder  extends BaseDocumentBuilder {
    private String firstName;
    private String lastName;
    private String middleName;
    private String fullName;
    private String firstNameLat;
    private String lastNameLat;
    private String middleNameLat;
    private String fullNameLat;
    private String country;
    private LocalDate issueDate;
    private String additionalInformation;
    private String issuerSubdivisionCode;
    private String registrationRegion;
    private LocalDate registrationDate;
    private String registrationLocality;
    private String registrationStreet;
    private String registrationHouse;
    private String registrationHousing;
    private String registrationApartement;
    private String registrationAddress;
    private String carNumber;
    private String vin;
    private String model;
    private String modelLat;
    private String ecoClass;
    private String type;
    private String category;
    private String year;
    private String shasiNumber;
    private String bodyNumber;
    private String color;
    private String power;
    private String maxWeight;
    private String withoutLoadWeight;
    private String temporaryReg;
    private String pts;

    public String firstName() {
        return firstName;
    }

    public VehicleRegistrationCertificateBuilder firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String lastName() {
        return lastName;
    }

    public VehicleRegistrationCertificateBuilder lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String middleName() {
        return middleName;
    }

    public VehicleRegistrationCertificateBuilder middleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    public String fullName() {
        return fullName;
    }

    public VehicleRegistrationCertificateBuilder fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public String firstNameLat() {
        return firstNameLat;
    }

    public VehicleRegistrationCertificateBuilder firstNameLat(String firstNameLat) {
        this.firstNameLat = firstNameLat;
        return this;
    }

    public String lastNameLat() {
        return lastNameLat;
    }

    public VehicleRegistrationCertificateBuilder lastNameLat(String lastNameLat) {
        this.lastNameLat = lastNameLat;
        return this;
    }

    public String middleNameLat() {
        return middleNameLat;
    }

    public VehicleRegistrationCertificateBuilder middleNameLat(String middleNameLat) {
        this.middleNameLat = middleNameLat;
        return this;
    }

    public String fullNameLat() {
        return fullNameLat;
    }

    public VehicleRegistrationCertificateBuilder fullNameLat(String fullNameLat) {
        this.fullNameLat = fullNameLat;
        return this;
    }

    public String country() {
        return country;
    }

    public VehicleRegistrationCertificateBuilder country(String country) {
        this.country = country;
        return this;
    }

    public LocalDate issueDate() {
        return issueDate;
    }

    public VehicleRegistrationCertificateBuilder issueDate(LocalDate issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    public String additionalInformation() {
        return additionalInformation;
    }

    public VehicleRegistrationCertificateBuilder additionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    public String issuerSubdivisionCode() {
        return issuerSubdivisionCode;
    }

    public VehicleRegistrationCertificateBuilder issuerSubdivisionCode(String issuerSubdivisionCode) {
        this.issuerSubdivisionCode = issuerSubdivisionCode;
        return this;
    }

    public String registrationRegion() {
        return registrationRegion;
    }

    public VehicleRegistrationCertificateBuilder registrationRegion(String registrationRegion) {
        this.registrationRegion = registrationRegion;
        return this;
    }

    public LocalDate registrationDate() {
        return registrationDate;
    }

    public VehicleRegistrationCertificateBuilder registrationDate(LocalDate registrationDate) {
        this.registrationDate = registrationDate;
        return this;
    }

    public String registrationLocality() {
        return registrationLocality;
    }

    public VehicleRegistrationCertificateBuilder registrationLocality(String registrationLocality) {
        this.registrationLocality = registrationLocality;
        return this;
    }

    public String registrationStreet() {
        return registrationStreet;
    }

    public VehicleRegistrationCertificateBuilder registrationStreet(String registrationStreet) {
        this.registrationStreet = registrationStreet;
        return this;
    }

    public String registrationHouse() {
        return registrationHouse;
    }

    public VehicleRegistrationCertificateBuilder registrationHouse(String registrationHouse) {
        this.registrationHouse = registrationHouse;
        return this;
    }

    public String registrationHousing() {
        return registrationHousing;
    }

    public VehicleRegistrationCertificateBuilder registrationHousing(String registrationHousing) {
        this.registrationHousing = registrationHousing;
        return this;
    }

    public String registrationApartement() {
        return registrationApartement;
    }

    public VehicleRegistrationCertificateBuilder registrationApartement(String registrationApartement) {
        this.registrationApartement = registrationApartement;
        return this;
    }

    public String registrationAddress() {
        return registrationAddress;
    }

    public VehicleRegistrationCertificateBuilder registrationAddress(String registrationAddress) {
        this.registrationAddress = registrationAddress;
        return this;
    }

    public String carNumber() {
        return carNumber;
    }

    public VehicleRegistrationCertificateBuilder carNumber(String carNumber) {
        this.carNumber = carNumber;
        return this;
    }

    public String vin() {
        return vin;
    }

    public VehicleRegistrationCertificateBuilder vin(String vin) {
        this.vin = vin;
        return this;
    }

    public String model() {
        return model;
    }

    public VehicleRegistrationCertificateBuilder model(String model) {
        this.model = model;
        return this;
    }

    public String modelLat() {
        return modelLat;
    }

    public VehicleRegistrationCertificateBuilder modelLat(String modelLat) {
        this.modelLat = modelLat;
        return this;
    }

    public String ecoClass() {
        return ecoClass;
    }

    public VehicleRegistrationCertificateBuilder ecoClass(String ecoClass) {
        this.ecoClass = ecoClass;
        return this;
    }

    public String type() {
        return type;
    }

    public VehicleRegistrationCertificateBuilder type(String type) {
        this.type = type;
        return this;
    }

    public String category() {
        return category;
    }

    public VehicleRegistrationCertificateBuilder category(String category) {
        this.category = category;
        return this;
    }

    public String year() {
        return year;
    }

    public VehicleRegistrationCertificateBuilder year(String year) {
        this.year = year;
        return this;
    }

    public String shasiNumber() {
        return shasiNumber;
    }

    public VehicleRegistrationCertificateBuilder shasiNumber(String shasiNumber) {
        this.shasiNumber = shasiNumber;
        return this;
    }

    public String bodyNumber() {
        return bodyNumber;
    }

    public VehicleRegistrationCertificateBuilder bodyNumber(String bodyNumber) {
        this.bodyNumber = bodyNumber;
        return this;
    }

    public String color() {
        return color;
    }

    public VehicleRegistrationCertificateBuilder color(String color) {
        this.color = color;
        return this;
    }

    public String power() {
        return power;
    }

    public VehicleRegistrationCertificateBuilder power(String power) {
        this.power = power;
        return this;
    }

    public String maxWeight() {
        return maxWeight;
    }

    public VehicleRegistrationCertificateBuilder maxWeight(String maxWeight) {
        this.maxWeight = maxWeight;
        return this;
    }

    public String withoutLoadWeight() {
        return withoutLoadWeight;
    }

    public VehicleRegistrationCertificateBuilder withoutLoadWeight(String withoutLoadWeight) {
        this.withoutLoadWeight = withoutLoadWeight;
        return this;
    }

    public String temporaryReg() {
        return temporaryReg;
    }

    public VehicleRegistrationCertificateBuilder temporaryReg(String temporaryReg) {
        this.temporaryReg = temporaryReg;
        return this;
    }

    public String pts() {
        return pts;
    }

    public VehicleRegistrationCertificateBuilder pts(String pts) {
        this.pts = pts;
        return this;
    }

    @Override
    public void writeFields(JsonWriterBase writer) throws IOException {
        super.writeFields(writer);
        writer.key("first_name");
        writer.value(firstName());
        writer.key("last_name");
        writer.value(lastName());
        writer.key("middle_name");
        writer.value(middleName());
        writer.key("full_name");
        writer.value(fullName());
        writer.key("first_name_lat");
        writer.value(firstNameLat());
        writer.key("last_name_lat");
        writer.value(lastNameLat());
        writer.key("middle_name_lat");
        writer.value(middleNameLat());
        writer.key("full_name_lat");
        writer.value(fullNameLat());
        writer.key("country");
        writer.value(country());
        writer.key("issue_date");
        writer.value(issueDate());
        writer.key("additional_information");
        writer.value(additionalInformation());
        writer.key("issuer_subdivision_code");
        writer.value(issuerSubdivisionCode());
        writer.key("registration_region");
        writer.value(registrationRegion());
        writer.key("registration_date");
        writer.value(registrationDate());
        writer.key("registration_locality");
        writer.value(registrationLocality());
        writer.key("registration_street");
        writer.value(registrationStreet());
        writer.key("registration_house");
        writer.value(registrationHouse());
        writer.key("registration_housing");
        writer.value(registrationHousing());
        writer.key("registration_apartement");
        writer.value(registrationApartement());
        writer.key("registration_address");
        writer.value(registrationAddress());
        writer.key("car_number");
        writer.value(carNumber());
        writer.key("vin");
        writer.value(vin());
        writer.key("model");
        writer.value(model());
        writer.key("model_lat");
        writer.value(modelLat());
        writer.key("eco_class");
        writer.value(ecoClass());
        writer.key("type");
        writer.value(type());
        writer.key("category");
        writer.value(category());
        writer.key("year");
        writer.value(year());
        writer.key("shasi_number");
        writer.value(shasiNumber());
        writer.key("body_number");
        writer.value(bodyNumber());
        writer.key("color");
        writer.value(color());
        writer.key("power");
        writer.value(power());
        writer.key("max_weight");
        writer.value(maxWeight());
        writer.key("without_load_weight");
        writer.value(withoutLoadWeight());
        writer.key("temporary_reg");
        writer.value(temporaryReg());
        writer.key("pts");
        writer.value(pts());
    }

    @Override
    public VehicleRegistrationCertificateBuilder parse(JsonMap map) throws JsonException {
        super.parse(map);
        this.firstName(map.getString("first_name", null));
        this.lastName(map.getString("last_name", null));
        this.middleName(map.getString("middle_name", null));
        this.fullName(map.getString("full_name", null));
        this.firstNameLat(map.getString("first_name_lat", null));
        this.lastNameLat(map.getString("last_name_lat", null));
        this.middleNameLat(map.getString("middle_name_lat", null));
        this.fullNameLat(map.getString("full_name_lat", null));
        this.country(map.getString("country", null));
        this.issueDate(map.get("issue_date", null, this::parseLocalDate));
        this.additionalInformation(map.getString("additional_information", null));
        this.issuerSubdivisionCode(map.getString("issuer_subdivision_code", null));
        this.registrationRegion(map.getString("registration_region", null));
        this.registrationDate(map.get("registration_date", null, this::parseLocalDate));
        this.registrationLocality(map.getString("registration_locality", null));
        this.registrationStreet(map.getString("registration_street", null));
        this.registrationHouse(map.getString("registration_house", null));
        this.registrationHousing(map.getString("registration_housing", null));
        this.registrationApartement(map.getString("registration_apartement", null));
        this.registrationAddress(map.getString("registration_address", null));
        this.carNumber(map.getString("car_number", null));
        this.vin(map.getString("vin", null));
        this.model(map.getString("model", null));
        this.modelLat(map.getString("model_lat", null));
        this.ecoClass(map.getString("eco_class", null));
        this.type(map.getString("type", null));
        this.category(map.getString("category", null));
        this.year(map.getString("year", null));
        this.shasiNumber(map.getString("shasi_number", null));
        this.bodyNumber(map.getString("body_number", null));
        this.color(map.getString("color", null));
        this.power(map.getString("power", null));
        this.maxWeight(map.getString("max_weight", null));
        this.withoutLoadWeight(map.getString("without_load_weight", null));
        this.temporaryReg(map.getString("temporary_reg", null));
        this.pts(map.getString("pts", null));
        return this;
    }
}
