#!/bin/bash
set -exo pipefail
source recommended_java_args.sh
source classpath.sh
source images_proxy.gc.args.sh
source images_proxy_config.sh

export TVM_API_HOST=https://tvm-api.yandex.net

export LJINX_WORKERS=2
export DOCUMENTS_APP_PORT=81
export DOCUMENTS_APP_DEBUG_PORT=82

MEM_ARGS="-Xms${XMS} -Xmx${XMX}  -Xmn384M -Xmaxf0.4 -Xminf0.2 -Xmine256M -Xmaxe1G -Xmint0.03"
GC_ARGS="-XX:ActiveProcessorCount=${CPU_CORES} -Xgcpolicy:balanced -verbose:gc -Xverbosegclog:/logs/gc#.log,10,10000"
DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"

exec $BSCONFIG_IDIR/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=images_proxy \
    -cp $CLASSPATH ru.yandex.passport.ImagesProxy images_proxy.conf
