package ru.yandex.passport;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;

public class ImageProxyRequestContext {
    private final ProxySession session;
    private final String documentId;
    private final String path;

    public ImageProxyRequestContext(ProxySession session) throws BadRequestException {
        this.session = session;
        this.documentId = session.params().getString("doc_id");
        this.path = session.params().getString("path");
    }

    public ProxySession session() {
        return session;
    }

    public String documentId() {
        return documentId;
    }

    public String path() {
        return path;
    }
}
