package ru.yandex.passport;

import java.io.IOException;

import ru.yandex.blackbox.BlackboxClient;
import ru.yandex.collection.Pattern;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.passport.config.ImmutableImagesProxyConfig;

public class ImagesProxy extends HttpProxy<ImmutableImagesProxyConfig> {
    private final BlackboxClient blackboxClient;
    private final AsyncClient avatarsClient;
    private final AsyncClient documentsProxyClient;

    public ImagesProxy(final ImmutableImagesProxyConfig config) throws IOException, ConfigException {
        super(config);
        this.blackboxClient = registerClient(
                        "Blackbox",
                        new BlackboxClient(reactor, config.blackbox()),
                        config.blackbox()
        );

        avatarsClient = client("Avatars", config.avatar());
        documentsProxyClient = client("Documents", config.documentsProxy());

        this.register(
                new Pattern<>("/get", false),
                new GetImageHandler(this)
        );
    }

    public BlackboxClient blackboxClient() {
        return blackboxClient;
    }

    public String blackboxTvm2Ticket() {
        return tvm2ClientTicketGenerator.ticket(config().blackboxTvmClientId());
    }

    public AsyncClient avatarsClient() {
        return avatarsClient;
    }

    public AsyncClient documentsProxyClient() {
        return documentsProxyClient;
    }
}
