package ru.yandex.passport;

import java.util.logging.Level;

import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;

public abstract class ImagesProxyCallback<T>  implements FutureCallback<T> {
    protected final ImageProxyRequestContext context;

    protected ImagesProxyCallback(ImageProxyRequestContext context) {
        this.context = context;
    }

    public ProxySession session() {
        return context.session();
    }

    @Override
    public void failed(Exception e) {
        context.session().logger().log(Level.WARNING, "Request error: ", e);
        context.session().response(HttpStatus.SC_INTERNAL_SERVER_ERROR);
    }

    @Override
    public void cancelled() {
        context.session().logger().log(Level.WARNING, "Request cancelled");
        context.session().response(HttpStatus.SC_INTERNAL_SERVER_ERROR);
    }
}
