package ru.yandex.passport.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.NonEmptyValidator;

public abstract class AbstractImagesProxyConfigBuilder
    <T extends AbstractImagesProxyConfigBuilder<T>>
     extends AbstractHttpProxyConfigBuilder<T>
     implements ImagesProxyConfig
{
    private HttpHostConfigBuilder avatar;
    private HttpHostConfigBuilder blackbox;
    private HttpHostConfigBuilder documentsProxy;
    private String blackboxTvmClientId;
    private String avatarsTvmClientId;

    protected AbstractImagesProxyConfigBuilder(final ImagesProxyConfig config) {
        super(config);
        avatar(config.avatar());
        blackbox(config.blackbox());
        blackboxTvmClientId(config.blackboxTvmClientId());
        avatarsTvmClientId(config.avatarsTvmClientId());
        documentsProxy(config.documentsProxy());
    }

    protected AbstractImagesProxyConfigBuilder(
        final IniConfig config,
        final ImagesProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.avatar =
            new HttpHostConfigBuilder(
                config.section("avatar"),
                defaults.avatar());
        this.blackbox =
                new HttpHostConfigBuilder(
                        config.section("blackbox"),
                        defaults.blackbox());
        this.blackboxTvmClientId = config.get(
                "blackbox.tvm-client-id",
                defaults.blackboxTvmClientId(),
                NonEmptyValidator.INSTANCE
        );
        this.avatarsTvmClientId = config.get(
                "avatar.tvm-client-id",
                defaults.avatarsTvmClientId(),
                NonEmptyValidator.INSTANCE
        );
        this.documentsProxy =
                new HttpHostConfigBuilder(
                        config.section("documents-proxy"),
                        defaults.documentsProxy());
    }

    @Override
    public HttpHostConfigBuilder avatar() {
        return avatar;
    }

    public T avatar(final HttpHostConfig avatar) {
        this.avatar = new HttpHostConfigBuilder(avatar);
        return self();
    }

    @Override
    public HttpHostConfigBuilder blackbox() {
        return blackbox;
    }

    public T blackbox(final HttpHostConfig blackbox) {
        this.blackbox = new HttpHostConfigBuilder(blackbox);
        return self();
    }

    @Override
    public HttpHostConfigBuilder documentsProxy() {
        return documentsProxy;
    }

    public T documentsProxy(final HttpHostConfig documentsProxy) {
        this.documentsProxy = new HttpHostConfigBuilder(documentsProxy);
        return self();
    }

    @Override
    public String blackboxTvmClientId() {
        return blackboxTvmClientId;
    }

    public T blackboxTvmClientId(final String blackboxTvmClientId) {
        this.blackboxTvmClientId = blackboxTvmClientId;
        return self();
    }

    @Override
    public String avatarsTvmClientId() {
        return avatarsTvmClientId;
    }

    public T avatarsTvmClientId(final String avatarsTvmClientId) {
        this.avatarsTvmClientId = avatarsTvmClientId;
        return self();
    }
}
