package ru.yandex.passport.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ImagesProxyConfigBuilder
     extends AbstractImagesProxyConfigBuilder<ImagesProxyConfigBuilder>
{
    public ImagesProxyConfigBuilder() {
        this(ImagesProxyConfigDefaults.INSTANCE);
    }

    public ImagesProxyConfigBuilder(final ImagesProxyConfig config) {
        super(config);
    }

    public ImagesProxyConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, ImagesProxyConfigDefaults.INSTANCE);
    }

    public ImagesProxyConfigBuilder(
        final IniConfig config,
        final ImagesProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableImagesProxyConfig build() throws ConfigException {
        return new ImmutableImagesProxyConfig(
            this);
    }

    @Override
    public ImagesProxyConfigBuilder self() {
        return this;
    }
}
