package ru.yandex.passport.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableImagesProxyConfig
     extends ImmutableHttpProxyConfig
     implements ImagesProxyConfig
{
    private final ImmutableHttpHostConfig avatar;
    private final ImmutableHttpHostConfig blackbox;
    private final ImmutableHttpHostConfig documentsProxy;
    private final String blackboxTvmClientId;
    private final String avatarsTvmClientId;

    public ImmutableImagesProxyConfig(
        final ImagesProxyConfig config)
        throws ConfigException
    {
        super(config);
        this.avatar = new ImmutableHttpHostConfig(config.avatar());
        this.blackbox = new ImmutableHttpHostConfig(config.blackbox());
        this.documentsProxy = new ImmutableHttpHostConfig(config.documentsProxy());
        this.blackboxTvmClientId = config.blackboxTvmClientId();
        this.avatarsTvmClientId = config.avatarsTvmClientId();
    }

    @Override
    public ImmutableHttpHostConfig avatar() {
        return avatar;
    }

    @Override
    public ImmutableHttpHostConfig blackbox() {
        return blackbox;
    }

    @Override
    public ImmutableHttpHostConfig documentsProxy() {
        return documentsProxy;
    }

    @Override
    public String blackboxTvmClientId() {
        return blackboxTvmClientId;
    }

    @Override
    public String avatarsTvmClientId() {
        return avatarsTvmClientId;
    }
}
