#!/bin/bash
set -exo pipefail
source config.sh
source classpath.sh

CPU_CORES_CORRECTION=${CPU_CORES_CORRECTION:-"0.2"}
if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk -v cores="$CPU_CORES_CORRECTION" '{print int($1 + cores)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk -v cores="$CPU_CORES_CORRECTION" '{print int($1 + cores)}')
fi

if [ "$MEM_LIMIT" != "" ]; then
    export MEMORY_LIMIT=$((MEM_LIMIT/100*80))
else
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | awk '{print int($1*0.8)}')
fi

if [ "$MEMORY_LIMIT" = "0" ]; then
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["memory_guarantee"]' | awk '{print int($1*0.8)}')
fi


portoctl run self/low command= isolate=false controllers[cpu]=true cpu_limit=1.5c cpu_period=10ms || true
portoctl run self/scripts command= isolate=false controllers[cpu]=true cpu_limit=0.3c || true

APP_ARGS="-DBSCONFIG_IPORT=$BSCONFIG_IPORT
-DBSCONFIG_IHOST=$BSCONFIG_IHOST
-DBSCONFIG_INAME=$BSCONFIG_INAME
-DMTN_TAG=$MTN_TAG
-DREPLICA_NAME=$REPLICA_NAME
"

CORE_DIR="/cores"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
export LD_LIBRARY_PATH=$BSCONFIG_IDIR:$BSCONFIG_IDIR/lstorage_service
export LD_PRELOAD=/usr/lib/libtcmalloc_minimal.so.4:$BSCONFIG_IDIR/libldpreload.so

source passport_search_gc_args.sh


export INDEX_THREADS=2
export MERGE_THREADS=1
export SEARCH_THREADS=$((CPU_CORES - 1))
export SEARCH_THREADS=$((SEARCH_THREADS - INDEX_THREADS))
export SEARCH_THREADS=$((SEARCH_THREADS - MERGE_THREADS))

if [ "$SEARCH_THREADS" -lt 2 ]; then
    export SEARCH_THREADS=5
fi

export LIMIT_SEARCH_REQUESTS=$((SEARCH_THREADS - 1))

exec $BSCONFIG_IDIR/jdk/bin/java \
    -Djava.rmi.server.hostname=$BSCONFIG_IHOST \
    -Djava.library.path=.:address_proxy \
    -verbose:gc \
    $NET_ARGS $GC_ARGS $APP_ARGS \
    -DPORTO=1 \
    -cp $CLASSPATH \
    ru.yandex.msearch.Daemon -config passport_search_backend.conf
