#!/bin/sh
if [ -x gc_args.sh.overrides ]; then
	exec ./gc_args.sh.overrides
    exit 0;
fi

mkdir -p /dev/shm/gclogs/ || true

XMX=$MEMORY_LIMIT
XMS=$((XMX / 4))

export GC_ARGS="
-XX:ActiveProcessorCount=$CPU_CORES
-XX:+IgnoreUnrecognizedVMOptions
-XX:+HeapDumpOnOutOfMemoryError
-XX:HeapDumpPath=/cores
-XcompilationThreads1
-Xmx1Gb
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:+UnlockExperimentalVMOptions
-verbose:gc
-XX:+UseShenandoahGC
-XX:ConcGCThreads=1
-XX:ShenandoahGCMode=traversal
-XX:-ShenandoahAlwaysClearSoftRefs
-XX:ShenandoahAllocationThreshold=5
-XX:ShenandoahUncommitDelay=30000
-XX:ShenandoahGuaranteedGCInterval=30000
-XX:ShenandoahGarbageThreshold=10
-XX:+PrintCodeCache
-XX:ParallelGCThreads=$CPU_CORES
-XX:MaxHeapFreeRatio=20
-XX:MinHeapFreeRatio=10
-XX:+UnlockDiagnosticVMOptions
-XX:+PrintGCDateStamps
-XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=2M
-Xlog:gc*:/dev/shm/gclogs/gc.log
"