package ru.yandex.passport.search;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.string.PositiveIntegerValidator;
import ru.yandex.parser.string.PositiveLongValidator;
import ru.yandex.parser.uri.CgiParams;

final class PassportMultidataSearchContext {
    private final ProxySession session;
    private final Long uid;
    private final String request;
    private final int length;

    public PassportMultidataSearchContext(
        final ProxySession session)
        throws BadRequestException {
        this.session = session;
        CgiParams params = session.params();
        this.uid = params.get("uid", PositiveLongValidator.INSTANCE);
        this.request = params.getString("request");
        this.length = params.get("length", PositiveIntegerValidator.INSTANCE);
    }

    public ProxySession session() {
        return session;
    }

    public Long uid() {
        return uid;
    }

    public String request() {
        return request;
    }

    public int length() {
        return length;
    }
}
