package ru.yandex.passport.search;

import java.util.Locale;

public enum SearchSource {
    MAIL {
        @Override
        public String searchUrl(long uid, String request) {
            return PassportMultidataSearchHandler.MAIL_BASE_SEARCH_URL.replace("{request}", request);
        }
    },
    DISK {
        @Override
        public String searchUrl(long uid, String request) {
            return PassportMultidataSearchHandler.DISK_BASE_SEARCH_URL.replace("{request}", request);
        }
    },
    MESSENGER_CONTACTS {
        @Override
        public String searchUrl(long uid, String request) {
            return null;
        }
    },
    PASSPORT {
        @Override
        public String searchUrl(long uid, String request) {
            return null;
        }
    };

    public abstract String searchUrl(final long uid, final String request);


    @Override
    public String toString() {
        return name().toLowerCase(Locale.ENGLISH);
    }
}
