package ru.yandex.passport.search;

import java.io.IOException;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

interface SerpItem extends JsonValue {
    SearchSource source();

    String id();

    long date();

    String name();

    String resourceUrl();

    String avatarUrl();

    String snippet();

    default void writeExtraFields(final JsonWriterBase writer)
        throws IOException
    {
    }

    @Override
    default void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("id");
        writer.value(id());
        writer.key("source");
        writer.value(source());
        writer.key("date");
        writer.value(date());
        writer.key("name");
        writer.value(name());
        writer.key("snippet");
        writer.value(snippet());
        writer.key("resource_url");
        writer.value(resourceUrl());
        writer.key("avatar_url");
        writer.value(avatarUrl());
        writeExtraFields(writer);
        writer.endObject();
    }
}
