package ru.yandex.passport.search.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractMultisearchConfigBuilder
    <T extends AbstractMultisearchConfigBuilder<T>>
     implements MultisearchConfig
{
    private HttpHostConfigBuilder mail;
    private HttpHostConfigBuilder disk;
    private PassportPortalConfigBuilder passport;

    public AbstractMultisearchConfigBuilder(final MultisearchConfig config) {
        mail(config.mail());
        disk(config.disk());
        passport(config.passport());
    }

    public AbstractMultisearchConfigBuilder(
        final IniConfig config,
        final MultisearchConfig defaults)
        throws ConfigException
    {
        this.mail =
            new HttpHostConfigBuilder(
                config.section("mail"),
                defaults.mail());
        this.disk =
            new HttpHostConfigBuilder(
                config.section("disk"),
                defaults.disk());
        this.passport =
            new PassportPortalConfigBuilder(
                config.section("passport"),
                defaults.passport());
    }

    @Override()
    public HttpHostConfigBuilder mail() {
        return mail;
    }

    public T mail(final HttpHostConfig value) {
        this.mail = new HttpHostConfigBuilder(
            value);
        return self();
    }

    @Override()
    public HttpHostConfigBuilder disk() {
        return disk;
    }

    public T disk(final HttpHostConfig value) {
        this.disk = new HttpHostConfigBuilder(
            value);
        return self();
    }

    @Override()
    public PassportPortalConfigBuilder passport() {
        return passport;
    }

    public T passport(final PassportPortalConfig value) {
        this.passport = new PassportPortalConfigBuilder(value);
        return self();
    }

    public abstract T self();
}
