package ru.yandex.passport.search.config;

import java.io.File;

import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.FileParser;

public abstract class AbstractPassportPortalConfigBuilder
    <T extends AbstractPassportPortalConfigBuilder<T>>
     implements PassportPortalConfig
{
    private File staticFile;
    private String clickUrlTemplate;
    private File cacheFile;
    private URIConfigBuilder bunker;

    public AbstractPassportPortalConfigBuilder(final PassportPortalConfig config) {
        staticFile(config.staticFile());
        clickUrlTemplate(config.clickUrlTemplate());
        cacheFile(config.cacheFile());
        bunker(config.bunker());
    }

    public AbstractPassportPortalConfigBuilder(
        final IniConfig config,
        final PassportPortalConfig defaults)
        throws ConfigException
    {
        this.staticFile = config.getInputFile("static-file", defaults.staticFile());
        this.clickUrlTemplate =
            config.getString("click-url-template", defaults.clickUrlTemplate());
        this.cacheFile = config.get("cache-file", defaults.cacheFile(), FileParser.INSTANCE);
        this.bunker =
            new URIConfigBuilder(
                config.section("bunker"),
                defaults.bunker());
    }

    @Override()
    public File staticFile() {
        return staticFile;
    }

    public T staticFile(final File value) {
        this.staticFile = value;
        return self();
    }

    @Override()
    public String clickUrlTemplate() {
        return clickUrlTemplate;
    }

    public T clickUrlTemplate(final String value) {
        this.clickUrlTemplate = value;
        return self();
    }

    @Override()
    public File cacheFile() {
        return cacheFile;
    }

    public T cacheFile(final File value) {
        this.cacheFile = value;
        return self();
    }

    @Override()
    public URIConfigBuilder bunker() {
        return bunker;
    }

    public T bunker(final URIConfig value) {
        this.bunker = new URIConfigBuilder(
            value);
        return self();
    }

    public abstract T self();
}
