package ru.yandex.passport.search.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableMultisearchConfig
     implements MultisearchConfig
{
    private final ImmutableHttpHostConfig mail;
    private final ImmutableHttpHostConfig disk;
    private final ImmutablePassportPortalConfig passport;

    public ImmutableMultisearchConfig(
        final MultisearchConfig config)
        throws ConfigException
    {
        this.mail = new ImmutableHttpHostConfig(
            config.mail());
        this.disk = new ImmutableHttpHostConfig(
            config.disk());
        this.passport = new ImmutablePassportPortalConfig(
            config.passport());
    }

    @Override
    public ImmutableHttpHostConfig mail() {
        return mail;
    }

    @Override
    public ImmutableHttpHostConfig disk() {
        return disk;
    }

    @Override
    public ImmutablePassportPortalConfig passport() {
        return passport;
    }
}
