package ru.yandex.passport.search.config;

import java.io.File;

import ru.yandex.http.config.ImmutableURIConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutablePassportPortalConfig
     implements PassportPortalConfig
{
    private final File staticFile;
    private final String clickUrlTemplate;
    private final File cacheFile;
    private final ImmutableURIConfig bunker;

    public ImmutablePassportPortalConfig(
        final PassportPortalConfig config)
        throws ConfigException
    {
        this.staticFile = config.staticFile();
        this.clickUrlTemplate = config.clickUrlTemplate();
        this.cacheFile = config.cacheFile();
        this.bunker = new ImmutableURIConfig(
            config.bunker());
    }

    @Override
    public File staticFile() {
        return staticFile;
    }

    @Override
    public String clickUrlTemplate() {
        return clickUrlTemplate;
    }

    @Override
    public File cacheFile() {
        return cacheFile;
    }

    @Override
    public ImmutableURIConfig bunker() {
        return bunker;
    }
}
