package ru.yandex.passport.search.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class MultisearchConfigBuilder
     extends AbstractMultisearchConfigBuilder<MultisearchConfigBuilder>
{
    public MultisearchConfigBuilder() {
        this(MultisearchConfigDefaults.INSTANCE);
    }

    public MultisearchConfigBuilder(final MultisearchConfig config) {
        super(config);
    }

    public MultisearchConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, MultisearchConfigDefaults.INSTANCE);
    }

    public MultisearchConfigBuilder(
        final IniConfig config,
        final MultisearchConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableMultisearchConfig build() throws ConfigException {
        return new ImmutableMultisearchConfig(
            this);
    }

    @Override
    public MultisearchConfigBuilder self() {
        return this;
    }
}
