package ru.yandex.passport.search.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class PassportPortalConfigBuilder
     extends AbstractPassportPortalConfigBuilder<PassportPortalConfigBuilder>
{
    public PassportPortalConfigBuilder() {
        this(PassportPortalConfigDefaults.INSTANCE);
    }

    public PassportPortalConfigBuilder(final PassportPortalConfig config) {
        super(config);
    }

    public PassportPortalConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, PassportPortalConfigDefaults.INSTANCE);
    }

    public PassportPortalConfigBuilder(
        final IniConfig config,
        final PassportPortalConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutablePassportPortalConfig build() throws ConfigException {
        return new ImmutablePassportPortalConfig(
            this);
    }

    @Override
    public PassportPortalConfigBuilder self() {
        return this;
    }
}
