#!/bin/bash
set -exo pipefail
source phone_squatter_backend_config.sh
source classpath.sh

#./check_its_status.py || exit 1

#portoctl run self/low command= isolate=false controllers[cpu]=true cpu_limit=1c cpu_period=10ms || true
#portoctl run self/scripts command= isolate=false controllers[cpu]=true cpu_limit=0.3c || true

if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk '{print int($1 + 0.2)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1 + 0.2)}')
fi

export INDEX_THREADS=2
export MERGE_THREADS=1
# we add extra threads for disk/io etc
export SEARCH_THREADS=$(echo $CPU_CORES | awk '{print int($1 * 1.25)}')
export SEARCH_THREADS=$((SEARCH_THREADS - INDEX_THREADS))
export SEARCH_THREADS=$((SEARCH_THREADS - MERGE_THREADS))
export LIMIT_SEARCH_REQUESTS=$((SEARCH_THREADS - 2))

APP_ARGS="-DBSCONFIG_IPORT=$BSCONFIG_IPORT
-DBSCONFIG_IHOST=$BSCONFIG_IHOST
-DBSCONFIG_INAME=$BSCONFIG_INAME
-DMTN_TAG=$MTN_TAG
-DREPLICA_NAME=$REPLICA_NAME
-DINUM=$INUM
"

CORE_DIR="/cores"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
export LD_LIBRARY_PATH=$BSCONFIG_IDIR

#source ace_backend_ibm_gc_args.sh
source phone_squatter_shenandoah_gc_args.sh

exec $BSCONFIG_IDIR/jdk/bin/java \
    -Djava.rmi.server.hostname=$BSCONFIG_IHOST \
    -Djava.library.path=phone_squatter_backend \
    -verbose:gc \
    $NET_ARGS $GC_ARGS $APP_ARGS \
    -DPORTO=1 \
    -cp $CLASSPATH \
    ru.yandex.multistarter.MultiStarter \
    ru.yandex.dispatcher.consumer.ConsumerServer -config phone_squatter_backend_consumer.conf ";" \
    ru.yandex.msearch.Daemon -config phone_squatter_backend.conf
