#!/bin/sh

GB=$((1024*1024*1024))
GB1_5=$((GB + (GB/2)))
GB2_5=$((GB + GB + (GB/2)))
XMX=$(portoctl get self memory_limit_total)
XMX=$((XMX-GB2_5))

mkdir -p /webcache/javasharedresources/512m >/dev/null 2>&1
if [ -x gc_args.sh.overrides ]; then
	exec ./gc_args.sh.overrides
    exit 0;
fi
export GC_ARGS="
-XX:ActiveProcessorCount=10
-XX:+IgnoreUnrecognizedVMOptions
-XX:+HeapDumpOnOutOfMemoryError
-XX:HeapDumpPath=/cores
-XcompilationThreads1
-Xmx$XMX
-Xms1G
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:+UnlockExperimentalVMOptions
-verbose:gc
-XX:+UseShenandoahGC
-XX:ConcGCThreads=2
-XX:ShenandoahGCMode=traversal
-XX:-ShenandoahAlwaysClearSoftRefs
-XX:ShenandoahAllocationThreshold=5
-XX:ShenandoahUncommitDelay=30000
-XX:ShenandoahGuaranteedGCInterval=30000
-XX:ShenandoahGarbageThreshold=10
-XX:+PrintCodeCache
-XX:ParallelGCThreads=7
-XX:MaxHeapFreeRatio=20
-XX:MinHeapFreeRatio=10
-XX:+UnlockDiagnosticVMOptions
-XX:+PrintGCDateStamps
-XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=2M
-Xlog:gc*:/dev/shm/gclogs/gc.log
"