#!/bin/bash
set -exo pipefail

source phone_ownership_proxy_config.sh
source classpath.sh

CORE_DIR="/coredumps"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
export LD_LIBRARY_PATH=.
export SEARCHMAP_PATH="searchmap-yc.txt"
export SERVER_PORT=8080

export PROXY_WORKERS=$((CPU_CORES / 2))
if [ "$PROXY_WORKERS" -lt 4 ]; then
    export PROXY_WORKERS=4
fi

export CPU_CORES=5

XMX=$(portoctl get self memory_limit_total)
XMX=$(echo $XMX | gawk '{print int($1 * 0.8 / 1048576)}')
XMS=$((XMX / 4))
PHONE_OWNERSHIP_PROXY_CONFIG="phone_ownership_proxy.conf"
export INDEX_PATH="/ssd/phone_squatter/index"
export EDNA_HOST="edna-proxy-1.myt.yp-c.yandex.net:80"
export LOGIN="$(cat edna_secrets/edna_login)"
export PASSWORD="$(cat edna_secrets/edna_password)"

export BACKEND_BASE_PORT=81
export BACKEND_SEARCH_PORT=82
export BACKEND_INDEX_PORT=83

MEM_ARGS="-Xms${XMS}M -Xmx${XMX}M  -Xmn384M -Xmaxf0.4 -Xminf0.2 -Xmine256M -Xmaxe1G -Xmint0.03"
GC_ARGS="-XX:ActiveProcessorCount=${CPU_CORES} -Xgcpolicy:balanced -verbose:gc -Xverbosegclog:/logs/gc#.log,10,10000"
DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
exec $BSCONFIG_IDIR/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=phone_ownership_proxy \
    -DPO_QUEUE=$PO_QUEUE \
    -cp $CLASSPATH \
    ru.yandex.multistarter.MultiStarter \
    ru.yandex.passport.phone.ownership.PhoneOwnershipProxy $PHONE_OWNERSHIP_PROXY_CONFIG ";" \
    ru.yandex.dispatcher.producer.Producer phone_squatter_producer.conf
