package ru.yandex.passport.phone.ownership;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.CodingErrorAction;
import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public abstract class AbstractPhoneOwnershipProxyPrinter<T> extends AbstractProxySessionCallback<T> {
    protected AbstractPhoneOwnershipProxyPrinter(final ProxySession session) {
        super(session);
    }

    @Override
    public void failed(final Exception e) {
        session.logger().log(Level.WARNING, "Request failed", e);
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();
        try (OutputStreamWriter outWriter =
                 new OutputStreamWriter(
                     out,
                     CharsetUtils.acceptedCharset(session.request())
                         .newEncoder()
                         .onMalformedInput(
                             CodingErrorAction.REPLACE)
                         .onUnmappableCharacter(
                             CodingErrorAction.REPLACE));
             JsonWriter writer = JsonTypeExtractor.NORMAL.extract(session.params()).create(outWriter)) {
            writer.startObject();
            writer.key("status");
            writer.value("error");
            writer.key("reason");
            writer.value(e.getMessage());
            writer.endObject();
        } catch (IOException | HttpException ne) {
            super.failed(ne);
        }

        NByteArrayEntity entity =
            out.processWith(NByteArrayEntityFactory.INSTANCE);
        entity.setContentType(
            ContentType.APPLICATION_JSON.withCharset(
                    session.acceptedCharset())
                .toString());
        session.response(HttpStatus.SC_INTERNAL_SERVER_ERROR, entity);
        session.logger().log(Level.INFO, "Response body: " + new String(out.toByteArray()));
    }
}
